

from pathlib import Path
from typing import Optional, Dict, Any

import requests


def get_project_root() -> Path:

    return Path(__file__).resolve().parents[2]


def get_html(url: str, params: Optional[Dict[str, Any]] = None) -> str:

    print(f"[HTTP] GET {url} params={params}")

    headers = {
        "User-Agent": (
            "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) "
            "AppleWebKit/537.36 (KHTML, like Gecko) "
            "Chrome/129.0 Safari/537.36"
        )
    }

    try:
        response = requests.get(url, params=params, headers=headers, timeout=20)
        response.raise_for_status()
        return response.text
    except requests.HTTPError as e:
        status = getattr(e.response, "status_code", "unknown")
        final_url = getattr(e.response, "url", url)
        print(f"[HTTP] Error {status} for {final_url}: {e}")
        return ""
    except requests.RequestException as e:
       
        print(f"[HTTP] Request failed for {url}: {e}")
        return ""
