# src/scraping/run_scrapers.py

from typing import List, Dict
from pathlib import Path
import csv
import importlib

from .scrape_bbc import scrape_bbc
from .scrape_guardian import scrape_guardian
from .utils import get_project_root


def run_all_scrapers() -> None:

    all_articles: List[Dict[str, str]] = []


    bbc_articles = scrape_bbc()
    print(f"[Runner] BBC returned {len(bbc_articles)} articles.")
    all_articles.extend(bbc_articles)


    guardian_articles = scrape_guardian()
    print(f"[Runner] Guardian returned {len(guardian_articles)} articles.")
    all_articles.extend(guardian_articles)


    telegraph_module = importlib.import_module("src.scraping.scrape_telegraph")
    telegraph_articles = telegraph_module.scrape_telegraph()
    print(f"[Runner] Telegraph returned {len(telegraph_articles)} articles.")
    all_articles.extend(telegraph_articles)

    sky_module = importlib.import_module("src.scraping.scrape_sky")
    sky_articles = sky_module.scrape_sky()
    print(f"[Runner] Sky returned {len(sky_articles)} articles.")
    all_articles.extend(sky_articles)


    ft_module = importlib.import_module("src.scraping.scrape_ft")
    ft_articles = ft_module.scrape_ft()
    print(f"[Runner] FT returned {len(ft_articles)} articles.")
    all_articles.extend(ft_articles)


    root = get_project_root()
    out_path: Path = root / "data" / "raw" / "uk_budget_headlines.csv"

    fieldnames = ["source", "source_type", "date", "headline", "url"]

    with out_path.open("w", newline="", encoding="utf-8") as f:
        writer = csv.DictWriter(f, fieldnames=fieldnames)
        writer.writeheader()
        for art in all_articles:
            writer.writerow(art)

    print(f"[Runner] Saved {len(all_articles)} articles to {out_path}")


if __name__ == "__main__":
    run_all_scrapers()
